/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2013 Felix Tiede <info@pc-tiede.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef _KCAOSSL_UTILS_H
#define _KCAOSSL_UTILS_H

#include "common.h"

#include <openssl/asn1.h>
#include <openssl/evp.h>
#include <openssl/safestack.h>
#include <openssl/x509.h>

class QByteArray;
class QSslKey;
class QString;

namespace Kca {
namespace OpenSSL {

/**
 * Internal class with helper functions to interact with OpenSSL C library.
 *
 * @author Felix Tiede <info@pc-tiede.de>
 * @short Internal helper class.
 */
class Utils {
public:
  /** Default destructor to cleanup behind us. */
  ~Utils();

  /** Platform specific path to a source of random data. */
  static const char *random_source;

  /** Static list of default extensions for email certificates. */
  static const ExtensionList emailCertConstraints;

  /** Static OpenSSL digest loader. */
  static const EVP_MD* digest(const Digest digest);

  /** Static string to ASN.1 octet string. */
  static ASN1_OCTET_STRING* octetString(const QString& in);

  /** Static string to X.509 name converter. */
  static X509_NAME* x509name(const QByteArray& name);

  /** Static extension stack decoder. */
  static ExtensionList extensions(STACK_OF(X509_EXTENSION)* extensions);

private:
  /** Default constructor to run code needed on loading of this library. */
  Utils();

  static const Utils *instance;

};  /* End class Utils */

};  /* End namespace OpenSSL */
};  /* End namespace Kca */

#endif  /* _KCAOSSL_UTILS_H */
