/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2013 Felix Tiede <info@pc-tiede.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#define _KCAOSSL_UNIT_TESTABLE friend class SigningExceptionTest;

#include "../signingexception.h"

#include <QtCore/QObject>

#include <QtTest/QTest>

namespace Kca {
namespace OpenSSL {

/**
 * Unit test for custom exception class SigningException.
 *
 * @author Felix Tiede <info@pc-tiede.de>
 * @short SigningException unit test.
 */
class SigningExceptionTest : public QObject {
  Q_OBJECT

private slots:
  /** Test constructor by checking return values match input. */
  void testConstructor()
  {
    const char* desc = "Provided timestamps mismatch constraints.";
    SigningException ex(SigningException::SignCsr, SigningException::TimeConstraint, desc);

    QCOMPARE(ex.operation(), SigningException::SignCsr);
    QCOMPARE(ex.failure(), SigningException::TimeConstraint);
    QCOMPARE(strcmp(ex.what(), desc), 0);
  };
};  /* End class SigningExceptionTest */

};  /* End namespace OpenSSL */
};  /* End namespace Kca */

QTEST_MAIN(Kca::OpenSSL::SigningExceptionTest)
#include "signingexceptiontest.moc"
