/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2013 Felix Tiede <info@pc-tiede.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#define _KCAOSSL_UNIT_TESTABLE friend class CommonTest;

#define KEY_LENGTH 3072

#include "../common.h"
#include "../extension.h"
#include "../key.h"

#include <QtCore/QByteArray>
#include <QtCore/QObject>
#include <QtCore/QDebug>

#include <QtTest/QTest>

namespace Kca {
namespace OpenSSL {

class CommonTest : public QObject
{
  Q_OBJECT

private slots:
  void testRandom()
  {
    QVERIFY(random() != random());
  }

  void testDefaultExtensions()
  {
    QVERIFY(emailCertExtensions().length() > 0);
  }
};  /* End class CertificateTest */

};  /* End namespace OpenSSL */
};  /* End namespace Kca */

QTEST_MAIN(Kca::OpenSSL::CommonTest);
#include "commontest.moc"
