/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2013 Felix Tiede <info@pc-tiede.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef _KCAOSSL_SIGNINGEXCEPTION_H
#define _KCAOSSL_SIGNINGEXCEPTION_H

#include "export.h"

#include "opensslexception.h"

namespace Kca {
namespace OpenSSL {

class Certificate;

/**
 * Custom exception information for Certificate::sign() methods.
 * Extends OpenSSLException which provides most of the infrastructure already.
 *
 * @author Felix Tiede <info@pc-tiede.de>
 */
class _KCAOSSL_EXPORT SigningException : public OpenSSLException {

  _KCAOSSL_UNIT_TESTABLE
  friend class Certificate;

public:
  /** Operation throwing the exception. */
  enum Operation {
    SignCsr,    /**<thrown while signing a CSR. */
    SignCrl,    /**<thrown while signing a CRL. */
  };  /* End enum Operation */

  /** Failure which caused the exception. */
  enum Failure {
    NoCACertificate,  /**<Certificate is not a CA and can not sign. */
    KeyMismatch,      /**<signing key does not match signing certificate. */
    SerialConstraint, /**<serial number from SignatureDetails did not match constraint. */
    TimeConstraint,   /**<timestamps from SignatureDetails did not match constraints. */
    ExtensionError,   /**<a given extension could not be used during signing operation. */
    ObjectError,      /**<given object, CSR or CRL could not be decoded. */
  };  /* End enum Failure */

  /** Default destructor. */
  ~SigningException() throw();

  /** Returns operation causing this exception. */
  Operation operation() const throw() {
    return op;
  }

  /** Returns the reason of this exception. */
  Failure failure() const throw() {
    return fail;
  }

protected:
  /** Create exception with given values. */
  SigningException(Operation operation, Failure failure, const char* message,
                   const char* func = NULL, int line = 0) throw();

private:
  /** Operation in which exception was generated. */
  Operation op;

  /** Reason the exception was thrown. */
  Failure fail;
};  /* End class SigningException */

};  /* End namespace OpenSSL */
};  /* End namespace Kca */
#endif  /* _KCAOSSL_SIGNINGEXCEPTION_H */
