/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2013 Felix Tiede <info@pc-tiede.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef _KCAOSSL_OPENSSLEXCEPTION_H
#define _KCAOSSL_OPENSSLEXCEPTION_H

#include "export.h"

#include <exception>

namespace Kca {
namespace OpenSSL {

class Certificate;
class Extension;
class Key;
class Request;
class Utils;

/**
 * Custom exception class carrying OpenSSL library error information.
 *
 * @author Felix Tiede <info@pc-tiede.de>
 * @short OpenSSL library error carrier.
 */
class _KCAOSSL_EXPORT OpenSSLException : public std::exception {

  _KCAOSSL_UNIT_TESTABLE
  friend class Certificate;
  friend class Extension;
  friend class Key;
  friend class Request;
  friend class Utils;

public:
  /** Default destructor. */
  ~OpenSSLException() throw();

  /** Returns the (possibly translated) message of this exception. */
  const char * what() const throw() {
    return message;
  }

  /** Returns the method where the Exception was thrown. */
  const char * where() const throw() {
    return func;
  }

  /** Returns the line of method where the Exception was thrown. */
  int line() const throw() {
    return fileline;
  }

protected:
  /** Create exception with given values. */
  OpenSSLException(const char* message, const char* func = NULL, int line = 0) throw();

private:
  /** Detailed and probably translated description of reason. */
  const char *message;
  /** Function in which the exception was generated. */
  const char *func;
  /** Line in which the throw call appeared. */
  int fileline;
};  /* End class OpenSSLException */

};  /* End namespace OpenSSL */
};  /* End namespace Kca */
#endif  /* _KCAOSSL_OPENSSLEXCEPTION_H */
