/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2013 Felix Tiede <info@pc-tiede.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef _KCAOSSL_COMMON_H
#define _KCAOSSL_COMMON_H

#include "export.h"

#include <QtCore/QDateTime>
#include <QtCore/QtGlobal>

template < typename T > class QList;
class QByteArray;
class QSslKey;
class QString;

namespace Kca {
namespace OpenSSL {

  /** Available digests for signing operations. */
  enum Digest {
    RIPEMD160,
    SHA1,
    SHA256,
    SHA384,
    SHA512,
  };  /* End enum Digest */

  /** Available reasons for certificate revocation. */
  enum RevocationReason {
    Unspecified,          /**<No specific reason has been given. Should be avoided. */
    KeyCompromise,        /**<The private key of the certificate has been compromised. */
    CACompromise,         /**<The signing CA was compromised, probably used in a recursive revocation. */
    AffilitionChanged,    /**<The certificate's owner or usage changed its affiliation. */
    Superseded,           /**<The certificate was replaced with a new one. */
    CessationOfOperation, /**<The service associated with the certificate was discontinued. */
    CertificateHold,      /**<The certificate is temporarily on hold. */
    RemoveFromCRL = 8     /**<The certificate should be removed from CRL. Only used in delta CRLs. */
  };  /* End enum RevocationReason */

  class Extension;
  typedef QList< Extension > ExtensionList;

  /** Datatype for a single entry in a CRL */
  struct _KCAOSSL_EXPORT CRLEntry {
    quint64 serial;           /**<Serial number of revoked certificate. */
    RevocationReason reason;  /**<Reason the certificate was revoked. */
    QDateTime timestamp;      /**<Timestamp of revocation. */
  };  /* End struct CRLEntry */
  typedef QList< CRLEntry > CRL;

  /** Get string version of library. */
  _KCAOSSL_EXPORT QString version();
  /** Get build information string of library. */
  _KCAOSSL_EXPORT QString build_information();

  /**
   * Generate a 64bit random number using OpenSSL's
   * pseudo random number generation functions.
   *
   * @return A 64 bit long randum number or 0xFFFFFFFFFFFFFFFF (-1) if an error occurs.
   */
  _KCAOSSL_EXPORT quint64 random();

  /** Get a default list of extensions for S/MIME certificates, used for eMail protection. */
  _KCAOSSL_EXPORT ExtensionList emailCertExtensions();

};  /* End namespace OpenSSL */
};  /* End namespace Kca */

#endif  /* _KCAOSSL_COMMON_H */
