macro(GetSrcVersion)

########### Search installed VCS ###############
find_package(Git QUIET)
find_package(Subversion QUIET)

########### Perform information run on source dir ###############
if (GIT_FOUND)
  execute_process(COMMAND ${GIT_EXECUTABLE} describe --dirty --match "v[0-9]*"
    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
    OUTPUT_VARIABLE SRC_VERSION
    ERROR_QUIET
    OUTPUT_STRIP_TRAILING_WHITESPACE
   )
  if (SRC_VERSION)
    execute_process(COMMAND ${GIT_EXECUTABLE} log -n 1 "--format=\"%h\""
      WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
      OUTPUT_VARIABLE COMMIT
      ERROR_QUIET
      OUTPUT_STRIP_TRAILING_WHITESPACE
     )
    string(LENGTH ${COMMIT} LEN)
    math(EXPR LEN ${LEN}-2)
    string(SUBSTRING ${COMMIT} 1 ${LEN} COMMIT)

    execute_process(COMMAND ${GIT_EXECUTABLE} log -n 1 "--format=\"%cn (%cE)\""
      WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
      OUTPUT_VARIABLE COMMITTER
      ERROR_QUIET
      OUTPUT_STRIP_TRAILING_WHITESPACE
     )
    string(LENGTH ${COMMITTER} LEN)
    math(EXPR LEN ${LEN}-2)
    string(SUBSTRING ${COMMITTER} 1 ${LEN} COMMITTER)

    execute_process(COMMAND ${GIT_EXECUTABLE} log -n 1 "--format=\"%ci\""
      WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
      OUTPUT_VARIABLE COMMITTER_DATE
      ERROR_QUIET
      OUTPUT_STRIP_TRAILING_WHITESPACE
     )
    string(LENGTH ${COMMITTER_DATE} LEN)
    math(EXPR LEN ${LEN}-2)
    string(SUBSTRING ${COMMITTER_DATE} 1 ${LEN} COMMITTER_DATE)
  endif (SRC_VERSION)
endif (GIT_FOUND)

if (Subversion_FOUND)
  execute_process(COMMAND ${Subversion_SVN_EXECUTABLE} info
    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
    OUTPUT_VARIABLE SVN_INFO
    ERROR_QUIET
    OUTPUT_STRIP_TRAILING_WHITESPACE
   )
  if (SVN_INFO)
    string(REGEX REPLACE "^(.*\n)?URL: ([^\n]*).*" "\\2" SRC_VERSION ${SVN_INFO})
    string(REGEX REPLACE ".*(/[^/ ]+)" "\\1" SRC_VERSION ${SRC_VERSION})
    string(REGEX REPLACE "^(.*\n)?Revision: ([0-9]+).*" "\\2" COMMIT ${SVN_INFO})
    string(REGEX REPLACE "^(.*\n)?Last Changed Author: ([^\n]+).*" "\\2" COMMITTER ${SVN_INFO})
    string(REGEX REPLACE "^(.*\n)?Last Changed Date: ([^\\(]+).*" "\\2" COMMITTER_DATE ${SVN_INFO})
  endif (SVN_INFO)
endif (Subversion_FOUND)

if (NOT SRC_VERSION AND EXISTS ${CMAKE_SOURCE_DIR}/VERSION)
  file(STRINGS ${CMAKE_SOURCE_DIR}/VERSION VERSION_INFO NEWLINE_CONSUME)
  if (VERSION_INFO)
    string(REGEX REPLACE "^(.*\n)?Commit:[ \\t]+([0-9a-zA-Z]+).*" "\\2" COMMIT ${VERSION_INFO})
    string(REGEX REPLACE "^(.*\n)?Committer:[ \\t]+([^\n]+).*" "\\2" COMMITTER ${VERSION_INFO})
    string(REGEX REPLACE "^(.*\n)?Commit date:[ \\t]+([^\\(\n]+).*" "\\2" COMMITTER_DATE ${VERSION_INFO})
    string(REGEX REPLACE "^(.*\n)?Commit:.*\\(.*(v[0-9]+\\.[0-9]+(\\.[0-9]+)+).*\\).*"
      "\\2" SRC_VERSION ${VERSION_INFO}
     )
  else (VERSION_INFO)
    set(COMMIT " ")
    set(COMMITTER " ")
    set(COMMITTER_DATE " ")
    set(SRC_VERSION " ")
  endif (VERSION_INFO)
endif (NOT SRC_VERSION AND EXISTS ${CMAKE_SOURCE_DIR}/VERSION)

string(SUBSTRING ${SRC_VERSION} 1 -1 SRC_VERSION_STR)

# Construct a hexadecimal version from VCS version information
string(REGEX MATCHALL "[0-9]+[\\.-]" SRC_VERSION ${SRC_VERSION})

set(COUNTER 0)
FOREACH(VER ${SRC_VERSION})
  if(COUNTER GREATER 2)
    break()
  endif(COUNTER GREATER 2)
  string(LENGTH ${VER} len)
  math(EXPR len ${len}-1)
  string(SUBSTRING ${VER} 0 ${len} VER)
  if(${len} LESS 2)
    set(VER 0${VER})
  endif(${len} LESS 2)
  set(HEX_VERSION ${HEX_VERSION}${VER})
  math(EXPR COUNTER ${COUNTER}+1)
ENDFOREACH(VER)
set(SRC_VERSION "0x${HEX_VERSION}")

mark_as_advanced(SRC_VERSION SRC_VERSION_STR COMMIT COMMITTER COMMITTER_DATE)

########### Provide version information from git ###############

endmacro(GetSrcVersion)
