/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2010 Felix Tiede <info@pc-tiede.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef UNLOCKAUTHORITY_H
#define UNLOCKAUTHORITY_H

#include <QDialog>

class QString;

namespace Ui {
class unlockAuthority_base;
};

class UnlockAuthority : public QDialog
{
  Q_OBJECT
  public:
    struct Answer {
      QString keyfile;
      bool storeKeyfile;
      QString passphrase;
      bool noAutoLock;
    };

    UnlockAuthority(const QString& message, Answer* answer, QWidget* parent = 0);
    virtual ~UnlockAuthority();

  private slots:
    void accepted();
    void openFile();
    void rejected();

  private:
    Ui::unlockAuthority_base* ui_unlockAuthority_base;

    Answer* answer;
};

#endif // UNLOCKAUTHORITY_H
