/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2007 - 2013 Felix Tiede <info@pc-tiede.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include "kca.h"

#include "version.h"

#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusConnectionInterface>

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <KDE/KLocale>

static const char description[] =
    I18N_NOOP("A KDE 4 Certification Authority management tool");
static const char build_info[] =
    I18N_NOOP("Build information:\nCommit %1 by %2,\ncommitted on %3.");

int main(int argc, char **argv)
{
    KAboutData about("kca", 0, ki18n("kca"), KCA_VERSION, ki18n(description),
                     KAboutData::License_GPL, ki18n("(C) 2007 - 2013 Felix Tiede"),
                     ki18n(build_info).subs(GIT_COMMIT).subs(GIT_COMMITTER).subs(GIT_COMMITTER_DATE),
                           0, "info@pc-tiede.de");
    about.addAuthor( ki18n("Felix Tiede"), KLocalizedString(), "info@pc-tiede.de" );
    KCmdLineArgs::init(argc, argv, &about);

    KCmdLineOptions options;
    options.add("+[URL]", ki18n( "Document to open" ));
    KCmdLineArgs::addCmdLineOptions(options);
    KApplication app;

    kca *widget = new kca;

    // Restrict to a single running instance
    if (QDBusConnection::sessionBus().interface()->isServiceRegistered("de.pctiede.kCA")) {
      if (widget->instanceList().count() > 0) {
        //TODO: Add errormessage to stderr.
        exit (1);
      }
    }

    // see if we are starting with session management
    if (app.isSessionRestored())
    {
        RESTORE(kca);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            //kca *widget = new kca;
            widget->show();
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
                //kca *widget = new kca;
                widget->show();
            }
        }
        args->clear();
    }

    return app.exec();
}
