/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2007 - 2010 Felix Tiede <info@pc-tiede.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef KCA_H
#define KCA_H

#include <kxmlguiwindow.h>

#include "ui_prefs_base.h"

#include <QtCore/QHash>
#include <QtCore/QMultiHash>
#include <QtCore/QString>

class kcaView;

class KToggleAction;

class QDateTime;
class QStringList;

namespace kCA {
namespace Database {
class Database;
}; // End namespace Database

namespace DBus {
class Interface;
}; // End namespace DBus

class Authority;
}; // End namespace kCA

namespace kCA_ossl {
class Certificate;
class Request;
class Revocationlist;
}; // End namespace kCA_ossl

/**
 * This class serves as the main window for kca.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author %{AUTHOR} <%{EMAIL}>
 * @version %{VERSION}
 */
class kca : public KXmlGuiWindow
{
    friend class kCA::DBus::Interface;

    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    kca();

    /**
     * Default Destructor
     */
    virtual ~kca();

    QStringList instanceList() const;

protected slots:
    void signRequest(const quint32 authority, const kCA_ossl::Request& request,
                     const QDateTime& notBefore = QDateTime(), const QDateTime& notAfter = QDateTime());
    void revokeCertificate(const quint32 authority, const quint64 serial, const int reason = 0);
    void generateCrl(const quint32 authority = 0, const QString& targetfile = QString());

protected:
    QHash< quint32, kCA::Authority* > authorities;
    kCA::Database::Database *db_backend;

private slots:
    void delayedInit();

    void attachToDatabase();
    void openRequest();
    void importAuthorities();
    void optionsPreferences();

    void selectAuthority(const quint32 authority);
    void lockAuthority();
    void generateSingleCrl();
    void generateAllCrls();

    void exportCertificate();

    void requestSigned(const kCA_ossl::Certificate& certificate, const int error);
    void certificateRevoked(const quint32 authority, const quint64 serial, const int reason, const int error);
    void crlGenerated(const kCA_ossl::Revocationlist& crl, const int error);

private:
    /** Constants defining behavior of unlockAuthority dialog. */
    enum AuthorityAction {
      GenerateCrl,        /**<Produce message about CRL generation. */
      SignRequest,        /**<Produce message about request signing. */
      RevokeCertificate,  /**<Produce message about certificate revoking. */
    };

    void setupActions();
    bool unlockAuthority(const quint32 authority, const AuthorityAction action, const QString& details = QString());

    Ui::prefs_base ui_prefs_base ;
    kcaView *m_view;

    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;

    kCA::DBus::Interface *dbus_interface;

    QMultiHash< quint32, QString > crlExports;
};

#endif // _KCA_H_
