/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2010 Felix Tiede <info@pc-tiede.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef IMPORTAUTHORITIES_H
#define IMPORTAUTHORITIES_H

#include <QtGui/QDialog>

class QString;
class QStringList;

namespace Ui {
class importAuthorities_base;
};

class importAuthoritiesView : public QDialog
{
  Q_OBJECT
  public:
    importAuthoritiesView(QString* file, QStringList* result, bool* importKey, QWidget* parent);
    virtual ~importAuthoritiesView();

  private slots:
    void accepted();
    void openFile();
    void rejected();

  private:
    Ui::importAuthorities_base* ui_import_base;

    QString* file;
    QStringList* answer;
    bool* importKey;
};

#endif // IMPORTAUTHORITIES_H
