/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2010, 2011 Felix Tiede <info@pc-tiede.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef SQLITEDATABASEUPGRADE_H
#define SQLITEDATABASEUPGRADE_H

#include <QtCore/QString>
#include <QtCore/QThread>

#include <string>

struct sqlite3;
typedef struct sqlite3 sqlite3;

namespace kCA {

namespace Database {

class SQLiteDatabase;
class SQLiteDatabaseUpgrade : public QThread
{
  friend class SQLiteDatabase;

  protected:
    SQLiteDatabaseUpgrade(const QString& filename, const char* targetVersion, QObject* parent = 0);
    virtual ~SQLiteDatabaseUpgrade();

    void run();
    bool upgradeRequired() const;
    bool prepareUpgrade();

  private:
    bool upgradeNeeded, upgradeReady;
    int oldversion;
    QString dbFile;

    static const std::string tableAuthorities[];
    static const std::string tablePolicies[];
    static const std::string tableExtensions[];
    static const std::string tableCAExtensions[];
    static const std::string tableCertificates[];

    sqlite3 *source, *destination;
};

}; // End namespace Database
}; // End namespace kCA

#endif // SQLITEDATABASEUPGRADE_H
