/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2010 Felix Tiede <info@pc-tiede.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef _LIBKCAOSSL_X509ATTRIBUTE_H
#define _LIBKCAOSSL_X509ATTRIBUTE_H

#include "kca_ossl_export.h"

#include <QtCore/QObject>
#include <QtCore/QStringList>

class QString;

struct asn1_type_st;
typedef struct asn1_type_st ASN1_TYPE;

struct x509_attributes_st;
typedef struct x509_attributes_st X509_ATTRIBUTE;

/** Namespace for kca-local classes */
namespace kCA_ossl
{

class Certificate;
class Request;
class RequestPrivate;
class Revocationlist;

/**
 * Represents a X509 attribute for requests.
 * Basically adds an abstraction layer over OpenSSL X509_ATTRIBUTE.
 *
 * @short OpenSSL X509_ATTRIBUTE abstraction class.
 * @author Felix Tiede <info@pc-tiede.de>
 */
class _LIBKCAOSSL_EXPORT X509Attribute : public QObject
{
  friend class Certificate;
  friend class Request;
  friend class RequestPrivate;
  friend class Revocationlist;

  Q_OBJECT
  public:
    /** Creates an empty X509 attribute. */
    X509Attribute(QObject *parent = 0);
    /** Copy constructor. */
    X509Attribute(const X509Attribute &other, QObject *parent = 0);
    ~X509Attribute();

    /** Get OID of attribute. */
    const QString oid() const;
    /** Returns true if attribute contains a requested extension. */
    bool requestedExtension() const;

    /**
     * Get Values of attribute.
     */
    const QStringList &values() const;

  protected:
    /**
     * Create attribute from OpenSSL's internal attribute representation,
     * X509_ATTRIBUTE.
     *
     * @param other X509_ATTRIBUTE struct to be parsed.
     * @param parent Parent object of this instance, default 0. Not yet used.
     */
    X509Attribute(X509_ATTRIBUTE *other, QObject *parent = 0);

    /**
     * Gets OpenSSL's internal representation of attribute.
     */
    X509_ATTRIBUTE *internal() const;

  private:
    int nid;
    X509_ATTRIBUTE *osslData;

    QStringList valueList;
};

}

#endif // _LIBKCAOSSL_X509ATTRIBUTE_H
