/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2010 Felix Tiede <info@pc-tiede.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

#include "../x509attribute.h"

#include <QtCore/QMultiMap>
#include <QtCore/QString>
#include <QtTest/QTest>

using namespace kCA_ossl;

/**
 * Test class for X509Name.
 * @short X509Attribute test class
 * @author Felix Tiede <infor@pc-tiede.de>
 */
class X509AttributeTest : public QObject
{
  Q_OBJECT
  private slots:
    /** Test creation of empty X509Name. */
    void createEmpty()
    {
      X509Attribute test;
      QCOMPARE(test.values().length(), 0);
    }

    /** Test copy constructor. */
    void copy()
    {
      X509Attribute src;
      X509Attribute dst(src);
      QCOMPARE(dst.values().length(), src.values().length());
    }
};

QTEST_MAIN(X509AttributeTest)
#include "x509attributetest.moc"
