########### Provide version information from git ###############
find_package(Git QUIET)
if (GIT_FOUND)
  execute_process(COMMAND ${GIT_EXECUTABLE} log -n 1 "--format=\"%h\""
    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
    OUTPUT_VARIABLE GIT_COMMIT
    ERROR_QUIET
    OUTPUT_STRIP_TRAILING_WHITESPACE
   )
  if (GIT_COMMIT)
    string(LENGTH ${GIT_COMMIT} LEN)
    math(EXPR LEN ${LEN}-2)
    string(SUBSTRING ${GIT_COMMIT} 1 ${LEN} GIT_COMMIT)
  endif (GIT_COMMIT)
  execute_process(COMMAND ${GIT_EXECUTABLE} log -n 1 "--format=\"%cn (%cE)\""
    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
    OUTPUT_VARIABLE GIT_COMMITTER
    ERROR_QUIET
    OUTPUT_STRIP_TRAILING_WHITESPACE
   )
  if (GIT_COMMITTER)
    string(LENGTH ${GIT_COMMITTER} LEN)
    math(EXPR LEN ${LEN}-2)
    string(SUBSTRING ${GIT_COMMITTER} 1 ${LEN} GIT_COMMITTER)
  endif (GIT_COMMITTER)
  execute_process(COMMAND ${GIT_EXECUTABLE} log -n 1 "--format=\"%ci\""
    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
    OUTPUT_VARIABLE GIT_COMMITTER_DATE
    ERROR_QUIET
    OUTPUT_STRIP_TRAILING_WHITESPACE
   )
  if (GIT_COMMITTER_DATE)
    string(LENGTH ${GIT_COMMITTER_DATE} LEN)
    math(EXPR LEN ${LEN}-2)
    string(SUBSTRING ${GIT_COMMITTER_DATE} 1 ${LEN} GIT_COMMITTER_DATE)
  endif (GIT_COMMITTER_DATE)
  execute_process(COMMAND ${GIT_EXECUTABLE} describe --dirty --match "v[0-9]*"
    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
    OUTPUT_VARIABLE PKG_VERSION
    ERROR_QUIET
    OUTPUT_STRIP_TRAILING_WHITESPACE
   )
endif (GIT_FOUND)

if (NOT PKG_VERSION AND EXISTS ${CMAKE_SOURCE_DIR}/VERSION)
  file(STRINGS ${CMAKE_SOURCE_DIR}/VERSION VERSION_INFO NEWLINE_CONSUME)
  if (VERSION_INFO)
    string(REGEX REPLACE "^Git commit:[ \\t]+([0-9a-zA-Z]+).*" "\\1" GIT_COMMIT ${VERSION_INFO})
    string(REGEX REPLACE ".*Committer:[ \\t]+(.+ \\([^ ]+\\)).*" "\\1" GIT_COMMITTER ${VERSION_INFO})
    string(REGEX REPLACE
      ".*Commit date:[ \\t]+([1-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] [0-2][0-9]:[0-5][0-9]:[0-5][0-9] [-+][0-9][0-9][0-9][0-9]).*"
      "\\1" GIT_COMMITTER_DATE ${VERSION_INFO}
     )
    string(REGEX REPLACE
      "^Git commit:.*\\(.*(v[0-9]+\\.[0-9]+(\\.[0-9]+)+).*\\).*"
      "\\1" PKG_VERSION ${VERSION_INFO}
     )
  else (VERSION_INFO)
    set(GIT_COMMIT " ")
    set(GIT_COMMITTER " ")
    set(GIT_COMMITTER_DATE " ")
    set(PKG_VERSION " ")
  endif (VERSION_INFO)
endif (NOT PKG_VERSION AND EXISTS ${CMAKE_SOURCE_DIR}/VERSION)

string(SUBSTRING ${PKG_VERSION} 1 -1 PKG_VERSION)

mark_as_advanced(PKG_VERSION GIT_COMMIT GIT_COMMITTER GIT_COMMITTER_DATE)

########### Provide version information from git ###############

# Set up version.h with git-provided version information
configure_file(
  ${CMAKE_INPUT_DIR}/version.h.in
  ${CMAKE_OUTPUT_DIR}/version.h ESCAPE_QUOTES IMMEDIATE @ONLY
 )
