/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2010 Felix Tiede <info@pc-tiede.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include "unlockauthority.h"

#include "ui_unlockauthority_base.h"

#include <QtCore/QString>
#include <QtGui/QDialog>

#include <kfiledialog.h>

UnlockAuthority::UnlockAuthority(const QString& message, UnlockAuthority::Answer* answer, QWidget* parent) :
    QDialog(parent),
    ui_unlockAuthority_base(new Ui::unlockAuthority_base),
    answer(answer)
{
  Q_ASSERT(this->answer);

  ui_unlockAuthority_base->setupUi(this);

  ui_unlockAuthority_base->lblMessage->setText(message);

  if (answer->keyfile.isEmpty()) {
    ui_unlockAuthority_base->lnKeyFile->setText(i18n("internal key"));
    ui_unlockAuthority_base->lnKeyFile->setEnabled(false);
    ui_unlockAuthority_base->pbBrowse->setEnabled(false);
    ui_unlockAuthority_base->cbStoreKeyFile->setEnabled(false);
    ui_unlockAuthority_base->cbStoreKeyFile->setCheckState(Qt::Unchecked);
  }
  else
    ui_unlockAuthority_base->lnKeyFile->setText(answer->keyfile);

  connect(ui_unlockAuthority_base->pbBrowse, SIGNAL(pressed()), SLOT(openFile()));
  connect(ui_unlockAuthority_base->dlgButtons, SIGNAL(accepted()), SLOT(accepted()));
  connect(ui_unlockAuthority_base->dlgButtons, SIGNAL(rejected()), SLOT(rejected()));
}

UnlockAuthority::~UnlockAuthority()
{

}

void UnlockAuthority::openFile()
{
  QString filename = answer->keyfile;
  filename = KFileDialog::getOpenFileName(KUrl(filename), "*.key|" + i18n("Private key file")
                                              + "\n*.p8*|" + i18n("PKCS#8 private key file")
                                              + "\n*.*|" + i18n("(Any file)"),
                                          this, i18n("Select private key file to use"));

  if (filename.isEmpty())
    return;

  answer->keyfile = filename;
  ui_unlockAuthority_base->lnKeyFile->setText(filename);
}

void UnlockAuthority::accepted()
{
  answer->storeKeyfile = (ui_unlockAuthority_base->cbStoreKeyFile->checkState() == Qt::Checked);
  answer->noAutoLock = (ui_unlockAuthority_base->cbAutoLock->checkState() == Qt::Checked);
  answer->passphrase = ui_unlockAuthority_base->lnPassphrase->text();

  this->done(QDialog::Accepted);
}

void UnlockAuthority::rejected()
{
  answer->keyfile.clear();
  answer->passphrase.clear();

  this->done(QDialog::Rejected);
}
