/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2010 Felix Tiede <info@pc-tiede.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef SIGNREQUESTDIALOG_H
#define SIGNREQUESTDIALOG_H

#include "ui_signrequestdialog_base.h"

#include <libkca_ossl/x509name.h>

#include <QtCore/QDateTime>
#include <QtCore/QHash>
#include <QtCore/QList>
#include <QtCore/QString>

#include <QtGui/QDialog>

class QDate;
class QTime;

namespace kCA_ossl {
class Request;
class X509Extension;
};

namespace kCA {
class Authority;
};

class SignRequestDialog : public QDialog, public Ui::signRequestDialog_base
{
  Q_OBJECT
public:
  struct Settings {
    quint32 authority;
    bool supersede;
    QDateTime notBefore, notAfter;
    QList< const kCA_ossl::X509Extension* > extensions;

    Settings(const quint32 authority, const bool supersede,
             const QDateTime& notBefore, const QDateTime& notAfter) :
        authority(authority),
        supersede(supersede),
        notBefore(notBefore),
        notAfter(notAfter)
    {}
  };

  SignRequestDialog(const QHash< quint32, kCA::Authority* >& authorityList,
                    const kCA_ossl::Request& request, Settings* settings,
                    QWidget* parent = 0, Qt::WFlags flags = 0);
  virtual ~SignRequestDialog();

private slots:
  void accept();
  void reject();

  void authoritySelected(const int index);
  void dateChanged(const QDate& value);
  void timeChanged(const QTime& value);
  void supersedeChanged(const bool value);

private:
  bool authorityUnlocked;

  Settings *settings;
  QHash<quint32, kCA::Authority*> authorityList;
  QHash<QString, const kCA_ossl::X509Extension*> extMap;
  kCA_ossl::X509Name requestData;
};

#endif // SIGNREQUESTDIALOG_H
