/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2010 Felix Tiede <info@pc-tiede.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include "importauthorities.h"

#include "ui_importauthorities_base.h"

#include "authority.h"
#include "database.h"

#include <QtCore/QStringList>
#include <QtGui/QDialog>
#include <QtGui/QListWidgetItem>

#include <kfiledialog.h>

importAuthoritiesView::importAuthoritiesView(QString* file, QStringList* result, bool* importKey, QWidget* parent) :
    QDialog(parent),
    ui_import_base(new Ui::importAuthorities_base),
    file(file),
    answer(result),
    importKey(importKey)
{
  Q_ASSERT(this->file);
  Q_ASSERT(this->answer);
  Q_ASSERT(this->importKey);

  ui_import_base->setupUi(this);

  connect(ui_import_base->pbOpenFile, SIGNAL(pressed()), SLOT(openFile()));
  connect(ui_import_base->dlgButtons, SIGNAL(accepted()), SLOT(accepted()));
  connect(ui_import_base->dlgButtons, SIGNAL(rejected()), SLOT(rejected()));
}

importAuthoritiesView::~importAuthoritiesView()
{

}

void importAuthoritiesView::openFile()
{
  QString filename = ui_import_base->lnFile->text();
  filename = KFileDialog::getOpenFileName(KUrl(filename), "*.cnf|" + i18n("OpenSSL configuration file (*.cnf)"),
                                          this, i18n("Select configuration file to load"));

  if (filename.isEmpty())
    return;

  ui_import_base->lnFile->setText(filename);
  QStringList authorities = kCA::Authority::findAuthorities(filename);
  ui_import_base->cbImportKey->setEnabled(authorities.count() > 0);

  QListWidgetItem *entry;
  foreach (QString authority, authorities) {
    entry = new QListWidgetItem(authority);
    entry->setFlags(Qt::ItemIsUserCheckable | Qt::ItemIsEnabled);
    entry->setCheckState(Qt::Checked);
    ui_import_base->authoritiesList->addItem(entry);
  }

  *file = filename;
}

void importAuthoritiesView::accepted()
{
  *importKey = (ui_import_base->cbImportKey->checkState() == Qt::Checked);

  QListWidgetItem *entry;
  for (int i = 0; i < ui_import_base->authoritiesList->count(); ++i) {
    entry = ui_import_base->authoritiesList->item(i);
    if (entry && entry->checkState() == Qt::Checked)
      *answer << entry->text();
  }

  this->done(QDialog::Accepted);
}

void importAuthoritiesView::rejected()
{
  answer->clear();
  this->done(QDialog::Rejected);
}
