/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2010 Felix Tiede <info@pc-tiede.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "x509attribute.h"
#include "utils.h"

#include <openssl/asn1.h>
#include <openssl/safestack.h>
#include <openssl/x509.h>

using namespace kCA_ossl;

X509Attribute::X509Attribute(QObject *parent) :
    QObject(parent),
    nid(NID_undef),
    osslData(0)
{}

X509Attribute::X509Attribute(const X509Attribute &other, QObject *parent) :
    QObject(parent),
    nid(other.nid),
    osslData(0),
    valueList(other.valueList)
{
  if (other.osslData) {
    osslData = X509_ATTRIBUTE_dup(other.osslData);
  }
}

X509Attribute::X509Attribute(X509_ATTRIBUTE *other, QObject *parent) :
    QObject(parent),
    nid(NID_undef),
    osslData(0)
{
  if (other) {
    nid = OBJ_obj2nid(other->object);
    osslData = X509_ATTRIBUTE_dup(other);

    if (osslData->single == 0) {
      for (int i=0; i<other->value.set->stack.num; ++i) {
        valueList << QString(Utils::print(sk_ASN1_TYPE_value(other->value.set, i)->value.asn1_string));
      }
    }
    else {
      valueList << QString(Utils::print(other->value.single->value.bit_string));
    }
  }
}

X509Attribute::~X509Attribute()
{
  if (osslData)
    X509_ATTRIBUTE_free(osslData);
}

const QString X509Attribute::oid() const
{
  return Utils::oid(nid);
}

bool X509Attribute::requestedExtension() const
{
  return (nid == NID_ext_req);
}

const QStringList& X509Attribute::values() const
{
  return valueList;
}

X509_ATTRIBUTE *X509Attribute::internal() const
{
  if (osslData)
    return X509_ATTRIBUTE_dup(this->osslData);

  return 0;
}
