/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2010 Felix Tiede <info@pc-tiede.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

#include "../x509extension.h"

#include <QtCore/QMultiMap>
#include <QtCore/QString>
#include <QtTest/QTest>

using namespace kCA_ossl;

/**
 * Test class for X509Extension.
 * @short X509Extension test class
 * @author Felix Tiede <infor@pc-tiede.de>
 */
class X509ExtensionTest : public QObject
{
  Q_OBJECT
  private slots:
    void createEmpty()
    {
      X509Extension test;
      QCOMPARE(test.isCritical(), false);
      QCOMPARE(test.oid(), QString("0.0"));
      QCOMPARE(test.oidShortName(), QString("UNDEF"));
      QCOMPARE(test.oidLongName(), QString("undefined"));
      QCOMPARE(test.value(), QByteArray());
    }

    void create()
    {
      X509Extension test("", "nsComment", "Netscape Comment", "foobar", false);
      QCOMPARE(test.isCritical(), false);
      QCOMPARE(test.oidShortName(), QString("nsComment"));
      QCOMPARE(test.value(), QByteArray("foobar"));
    }

    void createCritical()
    {
      X509Extension test("basicConstraints", "CA:false", true);
      QCOMPARE(test.isCritical(), true);
      QCOMPARE(test.oidShortName(), QString("basicConstraints"));
      QCOMPARE(test.value(), QByteArray("CA:false"));
    }

    void createNewOid()
    {
      X509Extension test("1.3.6.1.4.1.29104.0.0.0", "testOid", "testPurposeOid", "foobar", false);
      QCOMPARE(test.isValid(), true);
      QCOMPARE(test.oidShortName(), QString("testOid"));
      QCOMPARE(test.value(), QByteArray("foobar"));
    }

    void copy()
    {
      X509Extension src("nsComment", "foobar", false);
      X509Extension dst(src);
      QCOMPARE(dst.isCritical(), src.isCritical());
      QCOMPARE(dst.oidShortName(), src.oidShortName());
      QCOMPARE(dst.value(), src.value());
    }

    void assignment()
    {
      X509Extension src("nsComment", "foobar", false);
      X509Extension dst = src;
      QCOMPARE(dst.isCritical(), src.isCritical());
      QCOMPARE(dst.oidShortName(), src.oidShortName());
      QCOMPARE(dst.value(), src.value());
    }
};

QTEST_MAIN(X509ExtensionTest)
#include "x509extensiontest.moc"
