/*
    kCA, a KDE Certification Authority management tool
    Copyright (C) 2010 Felix Tiede <info@pc-tiede.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef _LIBKCAOSSL_COMMONS_H
#define _LIBKCAOSSL_COMMONS_H

#include "kca_ossl_export.h"

#include <QtCore/QtGlobal>

template <typename T> class QList;

namespace kCA_ossl
{
  class X509Extension;

  /** Selects digest algorithm for signing procedures. */
  enum Digest
  {
    RIPEMD160,
    SHA1,
    SHA256,
    SHA384,
    SHA512,
  };

  /**
   * Collection of valid reasons to revoke a certificate,
   * taken from OpenSSL's CA tool's man-page.
   *
   * @author Felix Tiede <info@pc-tiede.de>
   */
  enum RevocationReason
  {
    Unspecified,          /**<No specific reason has been given. Should be avoided. */
    KeyCompromise,        /**<The private key of the certificate has been compromised. */
    CACompromise,         /**<The signing CA was compromised, probably used in a recursive revocation. */
    AffilitionChanged,    /**<The certificate's owner or usage changed its affiliation. */
    Superseded,           /**<The certificate was replaced with a new one. */
    CessationOfOperation, /**<The service associated with the certificate was discontinued. */
    CertificateHold,      /**<The certificate is temporarily on hold. */
    RemoveFromCRL = 8     /**<The certificate should be removed from CRL. Only used in delta CRLs. */
  };

  /** Selects operation for toPemFile(). */
  enum WriteMode
  {
    NoPrivateKey = 0x00,    /**<Do not store private key at all. */
    SameFile = 0x01,        /**<Use same file for public and private key. */
    OtherFile = 0x02,       /**<Use another file for private key. */
  };

  /**
   * Generate a 64bit random number using OpenSSL's
   * pseudo random number generation functions.
   *
   * @return A 64 bit long randum number or 0xFFFFFFFFFFFFFFFF (-1) if an error occurs.
   */
  _LIBKCAOSSL_EXPORT quint64 generateRandom();

  /** Get a default list of extensions for S/MIME certificates, used for eMail protection. */
  _LIBKCAOSSL_EXPORT const QList< const X509Extension* > emailCertExtensions();
}

#endif // _LIBKCAOSSL_COMMONS_H
